#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12325);
 script_bugtraq_id(5808);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0838");
	
			
 name["english"] = "RHSA-2002-211: gv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of gv prior to 3.5.8.

Gv is a user interface for the Ghostscript Postscript interpreter.
This version of gv is vulnerable to a buffer overflow when processing
malformed PDF or Postscript files.  An attacker, exploiting this flaw,
would need to be able to entice the local user into opening one of these
malformed files with the gv reader.  Optionally, the attacker could also
be a local user attempting to escalate privileges on the local machine.

It is important to note that other products use gv source code as a base
for their own versions of the postscript interpreter.  Given this,
at least two other products are vulnerable to this same flaw.  Namely,
ggv and kghostview. 

Solution : http://rhn.redhat.com/errata/RHSA-2002-211.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

msg_stub = "
The remote host is running a version of gv prior to 3.5.8.

Gv is a user interface for the Ghostscript Postscript interpreter.
This version of gv is vulnerable to a buffer overflow when processing
malformed PDF or Postscript files.  An attacker, exploiting this flaw,
would need to be able to entice the local user into opening one of these
malformed files with the gv reader.  Optionally, the attacker could also
be a local user attempting to escalate privileges on the local machine.

It is important to note that other products use gv source code as a base
for their own versions of the postscript interpreter.  Given this,
at least two other products are vulnerable to this same flaw.  Namely,
ggv and kghostview/kdegraphics.

Solution : http://rhn.redhat.com/errata/RHSA-2002-211.html
Risk factor : High";


if ( rpm_check( reference:"ggv-1.0.2-5.1", release:"RHEL2.1") ) 
{
	mymsg = string(msg_stub, "\nThe remote host is running a vulnerable version of ggv\n");
	security_hole(port:0, data:mymsg);
}

if ( rpm_check( reference:"gv-3.5.8-18.7x", yank:"x", release:"RHEL2.1") )
{
        mymsg = string(msg_stub, "\nThe remote host is running a vulnerable version of gv\n");
        security_hole(port:0, data:mymsg);
}


if ( rpm_check( reference:"kdegraphics-2.2.2-2.1", release:"RHEL2.1") )
{
        mymsg = string(msg_stub, "\nThe remote host is running a vulnerable version of kdegraphics\n");
        security_hole(port:0, data:mymsg);
}

