#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12326);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0985","CAN-2002-0986");
			
 name["english"] = "RHSA-2002-214: PHP mail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of PHP prior to 4.2.3.

PHP is a framework for developing active Web pages.  There is a flaw 
in this version which would allow a local user (with web-authoring
credentials) to create a PHP script that would bypass some built-in
safe checks and allow an external user to pass arguments directly to
the mail daemon.  An attacker, exploiting this flaw, would need to
find a PHP script which used the mail() function and then send it a
specially formatted string which would allow the attacker to potentially
escalate privileges or execute commands on the remote machine.  In addition,
a local user could create a PHP script which utilized the mail() function
and then use the script to escalate privileges locally.

Solution : http://rhn.redhat.com/errata/RHSA-2002-214.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the PHP package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"php-4.1.2-2.1.6", prefix:"php-", release:"RHEL2.1") ) 
	security_hole(0);
else if ( rpm_exists(rpm:"php-4", release:"RHEL2.1") )
	set_kb_item(name:"CAN-2002-0985", value:TRUE);

