#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12328);
 script_bugtraq_id(5689, 6157);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0970","CAN-2002-1151","CAN-2002-1247","CAN-2002-1306");
			
 name["english"] = "RHSA-2002-221: KDE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of KDE prior to 3.0.3.

KDE is a desktop environment for the Linux Operating system.  This
version of KDE has three critical bugs.  The first bug is in the
KDE SSL implementation present in the default browser Konqueror.
An attacker, exploiting this flaw, would need to be able to entice
the local user to browse to a malicious website.  Upon browsing,
the remote server could send a malformed certificate which would
overflow the Konqueror application and allow the attacker to execute
code.

The second bug is a cross-site scripting (XSS) bug within Konqueror.
An attacker, exploiting this flaw, would need to be able to entice
the local user to browse to a malicious webserver.  Upon browsing,
the attacker would be able to execute code under the privileges of
a potentially trusted server.

The third bug is in the KDE LAN browsing implementation (LISa).
An attacker, exploiting this bug, would need to have access to the
server on port 7741 (default) and have the ability to create a
specially formatted request to the server.

Solution : http://rhn.redhat.com/errata/RHSA-2002-221.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the KDE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"arts-2.2.2-3", release:"RHEL2.1") ) 
	security_hole(0);

if ( rpm_check( reference:"kdelibs-2.2.2-3", prefix:"kdelibs-", release:"RHEL2.1") )
        security_hole(0);

if ( rpm_check( reference:"kdenetwork-2.2.2-2", prefix:"kdenetwork-", release:"RHEL2.1") )
        security_hole(0);




