#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12329);
 script_bugtraq_id(6016);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1232");
			
 name["english"] = "RHSA-2002-224: ypserv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of ypserv prior to 2.5.

Ypserv is an NIS authentication server.  This version of ypserv is 
vulnerable to a remote Denial of Service (DoS) attack.  An attacker,
exploiting this flaw, would need to be able to send authentication 
requests to the server.  As more and more requests are sent, the ypserv
server would gradually consume available memory and potentially be stopped.

Solution : http://rhn.redhat.com/errata/RHSA-2002-224.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ypserv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"ypserv-1.3.12-2.AS21", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


