#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12330);
 script_version ("$Revision: 1.2 $");
			
 name["english"] = "RHSA-2002-227: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an outdated Linux kernel.

The Linux kernel is the core of the Operating system that handles
all the low-level applications such as drivers, disk IO, etc.
There are multiple flaws within this kernel which could allow a
local user to escalate privileges on the machine.

Solution : http://rhn.redhat.com/errata/RHSA-2002-227.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kernel-2.4.9-e.9", yank:"e", prefix:"kernel-", release:"RHEL2.1") ) 
	security_hole(0);


