#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12331);
 script_bugtraq_id(6024);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1235");
			
 name["english"] = "RHSA-2002-250: krb5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of krb5 prior to 1.2.7.

Kerberos is a network authentication system which allows for 
authentication across multiple platforms.  This version of krb5
is vulnerable to a remote overflow within the administrative daemon
(kadmind4).  An attacker, exploiting this flaw, would need the ability
to send specially formatted packets to the kadmind4 daemon.  

Solution : http://rhn.redhat.com/errata/RHSA-2002-250.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"krb5-1.2.2-15", prefix:"krb5-", release:"RHEL2.1") ) 
	security_hole(0);


