
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12332);
 script_bugtraq_id(5887);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0839","CAN-2002-0840","CAN-2002-0843","CAN-2002-1157");
			
 name["english"] = "RHSA-2002-251: apache";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of apache prior to 1.3.27. 

Apache is a Web Server.  This version of Apache has three distinct
flaws.

First, this version of Apache shipped with an application called
ApacheBench (ab) which is used to benchmark web servers.  An attacker,
exploiting this flaw, would need to be able to entice a local user
to run ApacheBench against a malicious webserver.  A successful attack
could lead to remote code execution on the local system.

Second, there are several Cross-site-scripting (XSS) flaws within the
default Error Pages.  An attacker, exploiting this flaw, would need to
be able to entice a user to browse a URL which contained malicious
code which could then potentially be executed with elevated trust.

Third, a flaw within the shared memory scoreboard could allow a local
user to send a KILL to the httpd server as user 'root'.  This results in
a Denial of Service (DoS).

Solution : http://rhn.redhat.com/errata/RHSA-2002-251.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apachepackage";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"apache-1.3.27-2", prefix:"apache-", release:"RHEL2.1") ) 
	security_hole(0);




