#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12333);
 script_bugtraq_id(4504);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0180");
	
			
 name["english"] = "RHSA-2002-255: Webalizer";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Webalizer prior to 2.01-10.

Webalizer is a tool that takes Web server logs and builds a 
comprehensive HTML report.  There is a flaw in the way that 
Webalizer handles replies from DNS servers during it's report
creation.  An attacker, exploiting this flaw, would need to be
able to connect to the web server with a qualified, long DNS
name.  The potential exploit would then be run the next time
the web administrator generates a log report.

Solution : http://rhn.redhat.com/errata/RHSA-2002-255.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Webalizer package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"webalizer-2.01_09-1.72", yank:"_",  release:"RHEL2.1") ) 
	security_hole(0);


