#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12334);
 script_bugtraq_id(6352);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1344");
	
			
 name["english"] = "RHSA-2002-256: wget";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of wget prior to 1.8.2-4.

This version of wget is vulnerable to a directory traversion
bug.  That is, a malicious FTP server which contains '/../' within
it's name could potentially overwrite sensitive files on the local
system.  An attacker, exploiting this flaw, would need to be able
to entice a local user to browse to their malicious FTP server using
wget.

Solution : http://rhn.redhat.com/errata/RHSA-2002-256.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wget package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"wget-1.8.2-4.72", release:"RHEL2.1") ) 
	security_hole(0);


