#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12335);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1165");
	
			
 name["english"] = "RHSA-2002-259: sendmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of sendmail prior to 8.12.7.

Sendmail is an application for sending and receiving email.  This
version of sendmail is vulnerable to an attack against SMRSH 
(Sendmail Restricted Shell).  SMRSH is *not* enabled by default.
An attacker, exploiting this flaw, would be able to break out of
their restricted shell by using special characters within their
commands.  

Solution : http://rhn.redhat.com/errata/RHSA-2002-259.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sendmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"sendmail-8.11.6-9.72.4", prefix:"sendmail-", release:"RHEL2.1") ) 
	security_hole(0);


