#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12336);
 script_bugtraq_id(6351, 6354);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1158","CAN-2002-1159");
			
 name["english"] = "RHSA-2002-261: Canna";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Canna prior to 3.5b3.

Canna is a kana-kanji conversion server for handling Japanese 
language character input.  An attacker, exploiting this flaw,
would need local privileges.  In addition, the 'Japanese language'
option would have needed to have been selected during server install.
A successful attack would give the attacker 'bin' user privileges.

Solution : http://rhn.redhat.com/errata/RHSA-2002-261.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Canna package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"Canna-3.5b2-50.as21.1", yank:"as", prefix:"Canna-", release:"RHEL2.1") ) 
	security_hole(0);


