#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12337);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1319","CAN-2003-0461");
			
 name["english"] = "RHSA-2002-263: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an outdated kernel.

The Red Hat kernel is the core of the Operating system and handles
the low-level functions such as device drivers.  There is a flaw
in this kernel which would allow a local user to exhaust resources
and render the Operating system as useless.  

Solution : http://rhn.redhat.com/errata/RHSA-2002-263.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kernel-2.4.9-e.10", yank:"e", prefix:"kernel-", release:"RHEL2.1") ) 
	security_hole(0);


