#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12338);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1320");
			
 name["english"] = "RHSA-2002-271: pine";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Pine prior to 4.45.

Pine is an mail/news client which is run from a Linux commandline.
There is a flaw in the way that Pine handles the 'From:' header 
which would allow a remote attacker to cause Pine to fail.  An 
attacker, exploiting this flaw, would need to know that a user was
using Pine and then send them a specially crafted email with a 
long 'From:' field.

Solution : http://rhn.redhat.com/errata/RHSA-2002-271.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pine package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"pine-4.44-7.21AS.0", yank:"AS", release:"RHEL2.1") ) 
	security_warning(0);


