#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12339);
 script_bugtraq_id(5296);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1336");
			
 name["english"] = "RHSA-2002-287: VNC";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of VNC which is vulnerable
to a replay attack.

VNC is a tool for remotely administering a server or workstation.
There is a flaw in this version of VNC which would allow an attacker
to sniff a DES challenge-response and then 'replay' it on the network
in order to gain access to the system.  An attacker, exploiting this 
flaw, would need local access to the network (in order to sniff the
challenge) and then have the ability to duplicate the challenge within
a VNC request within one (1) second.

Solution : http://rhn.redhat.com/errata/RHSA-2002-287.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the VNC package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"vnc-3.3.3r2-18.5", yank:"r", prefix:"vnc-", release:"RHEL2.1") ) 
	security_hole(0);


