#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12340);
 script_bugtraq_id(6368, 6370, 6373, 6374, 6375);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1373","CAN-2002-1374","CAN-2002-1375","CAN-2002-1376");
			
 name["english"] = "RHSA-2002-289: MySQL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a verson of MySQL which is vulnerable
to several remote overflows.

MySQL is a multi-user, threaded SQL database server.  It is used by
many different packages and is often used in conjunction with a Web
Server.

This version of MySQL is vulnerable to several bugs.

First, a denial of service (DoS) bug is present wherein a remote
attacker can create a specially formatted query which causes a 
negative integer to be passed to a memcpy call.  An attacker, 
exploiting this bug, would need access to the MySQL server and
have the ability to pass SQL arguments to the server.

Second, the version of MySQL is vulnerable to a bug wherein it
can be coerced to only check the first character of a user's 
password.  An attacker, exploiting this bug, would need access 
to the MySQL server and have the ability to pass SQL arguments 
to the server.

Third, the version of MySQL client (libmysqlclient) is vulnerable
to a remote overflow when it receives a malformed response.  An
attacker, exploiting this flaw, would need to be able to coerce
the local user to connect to their malicious MySQL database and
issue the COM_CHANGE_USER command.

Solution : http://rhn.redhat.com/errata/RHSA-2002-289.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the MySQL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mysql-3.23.54a-3.72", yank:"a", prefix:"mysql-", release:"RHEL2.1") ) 
	security_hole(0);


