#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12342);
 script_bugtraq_id(6390);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1365");
			
 name["english"] = "RHSA-2002-294: Fetchmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Fetchmail prior to 6.2.0.

Fetchmail is an application which is used to retrieve and forward
email.  This version of Fetchmail is vulnerable to a remote overflow
when sent a specially crafted email.  An attacker, exploiting this
flaw, would need to have the ability to send a malformed message
to the address of a Fetchmail-parsed user.

Solution : http://rhn.redhat.com/errata/RHSA-2002-294.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Fetchmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"fetchmail-5.9.0-21.7.3", prefix:"fetchmail-", release:"RHEL2.1") ) 
	security_hole(0);


