#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12343);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0972","CAN-2002-1397","CAN-2002-1398","CAN-2002-1400","CAN-2002-1401");
			
 name["english"] = "RHSA-2002-301: PostgreSQL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a vulnerable version of PostgreSQL.

PostgreSQL is a relational database management system.  There are
several flaws within this version of PostgreSQL which can allow
for remote overflow in several of it's default routines.  An
attacker, exploiting these flaws, would need to have the ability
to directly connect to the server and execute queries.  A successful
attack could give the attacker the ability to execute code.

Solution : http://rhn.redhat.com/errata/RHSA-2002-301.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the PostgreSQL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"postgresql-7.1.3-4bp.2", yank:"bp", prefix:"postgresql", release:"RHEL2.1") ) 
	security_hole(0);


