#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12344);
 script_bugtraq_id(6384);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1377");
	
			
 name["english"] = "RHSA-2002-302: VIM";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of vim which is vulnerable
to remote command execution.

Vim is an enhanced editor.  This version of vim contains a flaw
wherein specially formatted file can lead to program execution
when opened by an unsuspecting user.  There is a function within
vim which allows a user to set the modeline differently for each
text file.  There is a flaw in the way that vim interprets comments
and this leads to arbitrary code execution.  An attacker, exploiting
this flaw, would need to entice a local user to open one of these
specially created files.

Solution : http://rhn.redhat.com/errata/RHSA-2002-302.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the VIM package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"vim-6.0-7.15", prefix:"vim-", release:"RHEL2.1") ) 
	security_hole(0);


