#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12345);
 script_bugtraq_id(6475);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1384");
			
 name["english"] = "RHSA-2002-307: Xpdf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Xpdf prior to 2.02.

Xpdf is a PDF reader for the X windows environment.  A flaw
within the rendering engine of Xpdf could lead to a remote
overflow.  An attacker, exploiting this bug, would need to
be able to entice a local user to open and view a malicious
PDF document.
 
Solution : http://rhn.redhat.com/errata/RHSA-2002-307.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Xpdf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"xpdf-0.92-8", release:"RHEL2.1") ) 
	security_hole(0);


