#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12346);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1378","CAN-2002-1379","CAN-2002-1508");
			
 name["english"] = "RHSA-2002-312: OpenLDAP";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a vulnerable version of OpenLDAP.

OpenLDAP is a suite of LDAP tools and API.  This version of OpenLDAP 
is vulnerable to 3 distinct bugs. 

First, commandline users can generate an overflow by passing long
arguments to the slurpd.  An attacker, exploiting this flaw, would
need local access and permission to run the slurpd binary.

Second, local users can modify configuration files in such a way
as to cause an overflow when binaries are initialized.  An attacker,
exploiting these flaws, would need local write access on the machine.

Third, when parsing an access control list, the slapd daemon can
be overflown.  An attacker, exploiting this flaw, would need local
write access on the machine.

Solution : http://rhn.redhat.com/errata/RHSA-2002-312.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenLDAP package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"openldap-2.0.27-2.7.3", prefix:"openldap-", release:"RHEL2.1") ) 
	security_hole(0);


