#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12347);
 script_bugtraq_id(6462);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1393");
script_cve_id("CAN-2002-1393");
			
 name["english"] = "RHSA-2003-003: KDE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of KDE which is vulnerable
to many character-escapes of input passed to a command shell.

KDE is a graphic environment for Linux.  This version of KDE
is vulnerable to multiple attacks wherein a user can pass a KDE
application a string with special characters which can coerce
KDE into passing unsafe arguments to the commandline.  An attacker,
exploiting this flaw, would need to have access to the KDE desktop
or be able to coerce a valid KDE user to execute specially formatted
commands.

Solution : http://rhn.redhat.com/errata/RHSA-2003-003.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the KDE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kdebase-2.2.2-6", prefix:"kde",  release:"RHEL2.1") ) 
	security_hole(0);


