#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12349);
 script_bugtraq_id(7302, 7303);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1391","CAN-2002-1392");
			
 name["english"] = "RHSA-2003-008: Mgetty";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of mgetty prior to 1.1.29.

Mgetty is a program for managing the configuration of a modem.
This version of mgetty is flawed in that, when used with Caller
ID, a long caller name could overflow the software.  An attacker,
exploiting this bug, would need to call the modem with a long
'Caller ID' display name.

Solution : http://rhn.redhat.com/errata/RHSA-2003-008.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Mgetty package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mgetty-1.1.30-0.7", prefix:"mgetty-", release:"RHEL2.1") ) 
	security_hole(0);


