#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12350);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1277");
			
 name["english"] = "RHSA-2003-009: WindowMaker";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of WindowMaker prior to 0.80.1

WindowMaker is an X windows manager.  This version of WindowMaker is
vulnerable to a buffer overflow when it processes a malicious theme
file.  An attacker, exploiting this bug, would need to coerce a local
user into opening a malicious window theme with WindowMaker.

Solution : http://rhn.redhat.com/errata/RHSA-2003-009.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the WindowMaker package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"WindowMaker-0.65.1-4.2", prefix:"WindowMaker-", release:"RHEL2.1") ) 
	security_hole(0);


