#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12351);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2003-0015");
			
 name["english"] = "RHSA-2003-013: CVS";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of CVS which is vulnerable
to a remote buffer overflow.

CVS is a version control system for managing multiple files within
a repository.  This version of CVS is vulnerable to a bug wherein
remote, authenticated users (or anonymous users, if enabled) can
give themselves 'write' access to the CVS repository.  Users who
already have 'write' privileges would be able to execute code on 
the CVS server.  An attacker, exploiting this flaw, would need to
have access to the CVS server either via userID/password or anonymous.

Solution : http://rhn.redhat.com/errata/RHSA-2003-013.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the CVS package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"cvs-1.11.1p1-8.7", yank:"p", prefix:"cvs-", release:"RHEL2.1") ) 
	security_hole(0);


