#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12352);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0435");
			
 name["english"] = "RHSA-2003-016: fileutils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of fileutils which is 
vulnerable to a local race condition.

Fileutils is a file management application which ships with
Red Hat Linux.  This version of fileutils is vulnerable to
a local race condition when fileutils is being run in recursive
(such as directory removal) mode.  An attacker, exploiting this
bug, would need local access on a shared server and further know
the exact time that the victim is running fileutils against
a directory that the attacker has 'write' access to.

Solution : http://rhn.redhat.com/errata/RHSA-2003-016.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the fileutils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"fileutils-4.1-10.1", release:"RHEL2.1") ) 
	security_hole(0);


