#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12353);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2003-0041");
	
			
 name["english"] = "RHSA-2003-021: Kerberos";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Kerberos which is vulnerable
to remote command execution.

Kerberos is a network authentication system. This version of Kerberos
FTP client contains a flaw wherein filenames which begin with a '|'
are passed to the client as a command to be executed.  An attacker,
exploiting this bug, would need to be able to coerce a local user into
downloading multiple files via Kerberos FTP client.  

Solution : http://rhn.redhat.com/errata/RHSA-2003-021.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Kerberos package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"krb5-1.2.2-16", prefix:"krb5-", release:"RHEL2.1") ) 
	security_hole(0);


