#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12354);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1146");
	
			
 name["english"] = "RHSA-2003-022: glibc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of glibc prior to 2.2.6

Glibc is a package of standard libraries which are used by many
different programs on a Linux system.  This version of glibc is
vulnerable when processing a malicious DNS response.  An attacker,
exploiting this flaw, would need to be able to either coerce a 
local system user into resolving a DNS name against a malicious
server or be able to sniff and hijack a valid DNS request.  

Solution : http://rhn.redhat.com/errata/RHSA-2003-022.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the glibc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"glibc-2.2.4-31.7", prefix:"glibc-", release:"RHEL2.1") ) 
	security_hole(0);


