#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12355);
 script_bugtraq_id(5429, 5430);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1467","CVE-2002-0846");
			
 name["english"] = "RHSA-2003-027: Netscape";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Netscape prior to 4.9

Netscape is a WWW browser.  This version of netscape is vulnerable
to several flaws via embedded active code.  An attacker, exploiting
these bugs, would need to be able to coerce a Netscape user to
browse to a malicious WWW server and execute active code within
the netscape browser.

Solution : http://rhn.redhat.com/errata/RHSA-2003-027.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Netscape package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"netscape-4.8-1", prefix:"netscape-", release:"RHEL2.1") ) 
	security_hole(0);


