#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12356);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1160");
			
 name["english"] = "RHSA-2003-028: PAM";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of pam_xauth which is vulnerable
to a local escalation of privileges bug.  

pam_xauth is a PAM module which is used to forward xauth information 
from user to user.  This version of pam_xauth would allow a user to
view password information for a user that has been executing commands
under their user ID.  For example, if the root user has used 'su' to 
assume the attackers ID, then the local attacker would be able to 
pull the root password from pam_xauth.

Solution : http://rhn.redhat.com/errata/RHSA-2003-028.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the PAM package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"pam-0.75-46.7.3", prefix:"pam-", release:"RHEL2.1") ) 
	security_hole(0);


