#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12357);
 script_bugtraq_id(5499);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1405");
			
 name["english"] = "RHSA-2003-030: Lynx";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Lynx which is vulnerable
to HTTP header injection.

Lynx is a text-based browser which is typically used from a Linux
command line.  This version of Lynx is vulnerable to an attack
wherein a URL with special characters can be used to inject HTTP
headers.  This can result in the Lynx user being silently redirected
to another site, being prompted for a password, etc.   An attacker,
exploiting this flaw, would need to create a malicious command line
argument or environmental variable which would be used by the victim
when opening Lynx.

Solution : http://rhn.redhat.com/errata/RHSA-2003-030.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Lynx package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"lynx-2.8.4-18.1", release:"RHEL2.1") ) 
	security_hole(0);


