#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12358);
 script_bugtraq_id(6213, 7090);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2002-1350","CAN-2003-0093");
			
 name["english"] = "RHSA-2003-033: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using a version of tcpdump which is vulnerable
to a remote Denial of Service (DoS) attack.

Tcpdump is a commandline protocol analyzer (or sniffer).  This
version of tcpdump has a problem with decoding BGP traffic which
can result in a DoS attack.  An attacker, exploiting this flaw,
would need to know that tcpdump was running on the remote host as
well as ascertain (or guess) that the pcap filter is accepting and
decoding BGP traffic.

Solution : http://rhn.redhat.com/errata/RHSA-2003-033.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"tcpdump-3.6.2-12.2.1AS.1", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);

