#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12359);
 script_bugtraq_id(6307);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1395");
			
 name["english"] = "RHSA-2003-038: Internet Message";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Internet Message (im)
that is vulnerable to a local temp file race condition.

IM is a set of user commands which use a Perl libary to integrate
email and news.  This version of IM is vulnerable to a flaw wherein
temporary file creation does not use truly random values to seed the
temp files.  An attacker, exploiting this flaw, would be able to guess
which files were about to be written and use this to exploit code against
the user running IM.  The attacker would need local access during the
time that the victim is running IM.

Solution : http://rhn.redhat.com/errata/RHSA-2003-038.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Internet Message package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"im-140-3.21AS.3", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


