#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12360);
 script_bugtraq_id(6793, 6794);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1335","CAN-2002-1348");
			
 name["english"] = "RHSA-2003-045: W3M";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of W3M prior to 0.3.2.3.

W3M is a pager with web-browsing capabilities.  This version of
W3M is vulnerable to several Cross-site-scripting (XSS) bugs.
An attacker, exploiting these bugs, would need to assume that
W3M was running with frames enabled (not the default) and be
able to coerce a user to traverse a link which had malicious
code within a frame.

Solution : http://rhn.redhat.com/errata/RHSA-2003-045.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the W3M package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"w3m-0.2.1-11.AS21.1", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


