#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12361);
 script_bugtraq_id(4637, 4640, 5665, 5694);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2002-0593","CAN-2002-1091","CAN-2002-1126","CVE-2002-0594");
			
 name["english"] = "RHSA-2003-046: Mozilla";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Mozilla prior to 1.0.1.

Mozilla is an open-source Web browser.  There are multiple flaws
in this version of Mozilla.  The flaws would allow an attacker to
potentially execute code through a malformed irc link, or read
local files through a bug in the way that Mozilla processes requests
for files.  An attacker, exploiting any of these flaws would need to
be able to coerce a local user into browsing to a malicious site.

Solution : http://rhn.redhat.com/errata/RHSA-2003-046.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Mozilla package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mozilla-1.0.1-2.2.1", prefix:"mozilla-", release:"RHEL2.1") ) 
	security_hole(0);


