#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12362);
 script_bugtraq_id(5581);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1119");
			
 name["english"] = "RHSA-2003-048: Mozilla";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Python prior to 2.2.2.

Python is an interpreted programming language.  This version of
python has a flaw which allows an attacker to predict name and 
location of temp files.  This can lead to symlink attacks by
local users.  An attacker, exploiting this flaw, would need to
have local access to the machine and be able to create symbolic
links to the temp folder that python uses when creating files. The
attacker would then just need to wait until some other user executed
python.  The attacker would then be able to gain elevated access on
the local machine.

Solution : http://rhn.redhat.com/errata/RHSA-2003-048.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Mozilla package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"python-1.5.2-43.72", prefix:"python-([0-9]|devel)", release:"RHEL2.1") ) 
	security_hole(0);


