#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12363);
 script_bugtraq_id(7790);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1155");
			
 name["english"] = "RHSA-2003-050: kon2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of kon prior to 0.3.9c.

KON is a kanji emulator.  This version of kon is vulnerable to
a local overflow via an unchecked buffer.  An attacker, exploiting
this bug, would be able to escalate their privileges to the 'root'
user.
 
Solution : http://rhn.redhat.com/errata/RHSA-2003-050.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kon2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kon2-0.3.9b-14.as21.1", yank:"as", prefix:"kon2-", release:"RHEL2.1") ) 
	security_hole(0);


