#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12364);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0036","CAN-2003-0028","CAN-2003-0058","CAN-2003-0059","CAN-2003-0072");
# CAN-2003-0082 CAN-2003-0138 CAN-2003-0139
			
 name["english"] = "RHSA-2003-052: kerberos";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of kerberos which is vulnerable
to multiple local and remote overflows.

Kerberos is a framework for authenticating across multiple platforms.

This version of kerberos is vulnerable to several bugs.

First, errors in the ASN.1 decoder can allow a remote user to
shut down the service.  An attacker, exploiting this flaw, would
need to have access to a kerberos application that used ASN.1
encoding.  

Two bugs in the Key Distribution Center (KDC) will allow a remote
attacker to cause the KDC to stop processing requests (DoS) and to
generate an overflow. An attacker, exploiting these flaws, would 
need access to the KDC TCP ports.

A bug in the way that Kerberos handles multiple realms would allow
a remote attacker to impersonate users in other realms that have
the same inter-realm key.  An attacker, exploiting this flaw, would
need to have a valid account within one realm that matched an inter-
realm key for another realm.

A bug in the way that Kerberos 4 handled triple-DES keys could allow
a remote attacker to cut themselves a key for any kerberos-protected
object.  An attacker, exploiting this flaw, would need network access
to the protected objects.  In addition, they would need to know that
the Kerberos infrastructure supported Kerberos 4 3-DES keying.

A vulnerability in the way that Kerberos' kadmin handles RPC can result
in a remote overflow.  An attacker, exploiting this flaw, would need
access to the local network and the ability to craft traffic to the
kadmin service.  A successful attack will result in a DoS.

Solution : http://rhn.redhat.com/errata/RHSA-2003-052.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kerberos package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"krb5-1.2.2-24", prefix:"krb5-", release:"RHEL2.1") ) 
	security_hole(0);


