#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12366);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1509");
			
 name["english"] = "RHSA-2003-058: shadow-utils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of shadow-utils which is 
vulnerable to a local bug.

Shadow-utils is a package for managing UNIX accounts.  This version
of Shadow-utils includes a program called 'useradd' which is used
to add a new user.  Useradd incorrectly creates new mail spool files
with read permissions given to userID and User's group.  On systems
where multiple users share the same group ID, all the users within a 
group can read all the mail for other users within the same group.
An attacker, exploiting this bug, would need local access and a 
non-unique Group ID.

Solution : http://rhn.redhat.com/errata/RHSA-2003-058.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the shadow-utils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"shadow-utils-20000902-9.7", release:"RHEL2.1") ) 
	security_hole(0);


