#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12367);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2003-0146");
			
 name["english"] = "RHSA-2003-061: NetPBM";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of NetPBM which is vulnerable
to local and remote exploits.

Netpbm is a package for handling graphics files.  A flaw in this
version of netpbm would allow an attacker to craft an image file
such that, upon processing, it would execute arbitrary code.  This
can lead to local and remote exploitation, as any application that
uses netpbm is vulnerable.  An example of remote exploitation would
include sending a malicious file to a Linux print daemon which uses
netpbm to handle the graphics.  There are many more permutations
of attack vectors.

Solution : http://rhn.redhat.com/errata/RHSA-2003-061.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the NetPBM package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"netpbm-9.24-9.AS21.2", yank:"AS", prefix:"netpbm-", release:"RHEL2.1") ) 
	security_hole(0);


