#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12368);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0078");
			
 name["english"] = "RHSA-2003-063: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of OpenSSL which is vulnerable
to man-in-the-middle (MITM) attacks.

OpenSSL is an open-source SSL/TLS implementation.  This version of
OpenSSL is vulnerable to a bug wherein an attacker (with access to
the network in such a way as to be able to see both sides of the SSL
connection) can time the encryption cipherblocks in such a way as to
be able to reduce the encrypted blocks to plaintext. An attacker, 
exploiting this flaw, would need:
1) Ability to sniff both sides of the SSL/TLS connection.

2) common fixed plaintext blocks (i.e. some plaintext which is always
encrypted at some predetermined time within a connection)

3) The ability to act as a MITM and modify data 'in transit'

  
Solution : http://rhn.redhat.com/errata/RHSA-2003-063.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

i=0;

if ( rpm_check( reference:"openssl-0.9.6b-30.7", yank:"b", prefix:"openssl-", release:"RHEL2.1") ) 
	i++;
	
if ( rpm_check( reference:"openssl095a-0.9.5a-18.7", yank:"a", prefix:"openssl095a-", release:"RHEL2.1") )
        i++;

if ( rpm_check( reference:"openssl096-0.9.6-13.7", prefix:"openssl096-", release:"RHEL2.1") )
        i++;

if (i > 0)
	security_hole(0);
else if ( rpm_exists(rpm:"openssl", release:"RHEL2.1") ) 
	{
	 set_kb_item(name:"CAN-2003-0078", value:TRUE);
	}
