#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12369);
 script_bugtraq_id(6940, 6950, 8032);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2001-1409","CAN-2002-0164","CAN-2002-1510","CAN-2003-0063","CAN-2003-0071");
			
 name["english"] = "RHSA-2003-065: XFree86";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of XFree86 which has multiple
vulnerabilities.

XFree86 is a GUI environment for Linux platforms.  This version of
XFree86 is vulnerable to several bugs wherein a local user can
cause XFree86 to fail (Denial of Service), elevate their privileges,
or read confidential data belonging to another user or process.  An 
attacker, exploiting these flaws, would need one of:

1) Local access and the ability to coerce a local user into 
pressing RETURN after malforming the victims Xterm window title.

2) network access to the xdm display manager coupled with a
nonexistent xdm auth directory.

3) Local access and the ability to write to the /dev/dri directory.

Solution : http://rhn.redhat.com/errata/RHSA-2003-065.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"XFree86-4.1.0-49", prefix:"XFree86-", release:"RHEL2.1") ) 
	security_hole(0);


