#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12370);
 script_bugtraq_id(6905);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1511");
			
 name["english"] = "RHSA-2003-068: VNC";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a vulnerable version of VNC.

VNC is a tool for giving remote users a graphical user 
interface into the local system.  This version of VNC
contains a flaw in the way that it generates authentication
cookies.  An attacker, exploiting this flaw, would need to
be able to connect to the VNC ports and guess a valid VNC
authentication cookie.

Solution: http://rhn.redhat.com/errata/RHSA-2003-068.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the VNC package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"vnc-3.3.3r2-18.6", yank:"r", release:"RHEL2.1") ) 
	security_hole(0);


