#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12371);
 script_bugtraq_id(6944);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0077","CAN-2003-0079");
			
 name["english"] = "RHSA-2003-071: Hangul Terminal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Hangul which contains a flaw in the
way that it handles escape sequences.

Hangul is a terminal emulator for X windows.  This version of
hangul contains the ability for the shell to set the window title. A
flaw in the way that hangul parses the window title could force
the window title to be displayed after the shell prompt.  An attacker,
exploiting this flaw, would need local access and the ability to
coerce another local user (notably 'root') to press the ENTER key
when the malicious command is presented after the shell prompt.

Solution : http://rhn.redhat.com/errata/RHSA-2003-071.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Hangul Terminal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"hanterm-xf-2.0.5-5.AS21.1", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


