#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12372);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-1337");
	
			
 name["english"] = "RHSA-2003-074: Sendmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Sendmail prior to 8.12.8.

Sendmail is a Mail Transport Agent which is used for sending and
receiving email.  A flaw in this version of Sendmail would allow
a remote attacker to craft an email such that, upon processing,
it would cause Sendmail to execute arbitrary code.  An attacker, 
exploiting this flaw, would need only craft and send an email to
a vulnerable sendmail machine.

Solution : http://rhn.redhat.com/errata/RHSA-2003-074.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Sendmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"sendmail-8.11.6-24.72", release:"RHEL2.1") ) 
	security_hole(0);


