#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12373);
 script_bugtraq_id(7050, 7493, 7494, 7495, 7878);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0081","CAN-2003-0159","CAN-2003-0356","CAN-2003-0357","CAN-2003-0428");
#CAN-2003-0429 CAN-2003-0430 CAN-2003-0431 CAN-2003-0432
			
 name["english"] = "RHSA-2003-077: Ethereal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of ethereal prior to 0.9.13.

This version of ethereal is vulnerable to multiple flaws within
it's protocol analysis modules.  An attacker can use these flaws
to execute code on the remote machine.  An attacker, exploiting
these flaws would need to know (or guess) that a remote user is
using ethereal to sniff network traffic.  Further, the attacker
would need to know that the user was sniffing one of the vulnerable
network protocols and displaying the protocols via the ethereal
protocol dissector.  The relevant protocols are:
SOCKS
NTLMSSP
AIM
GIOP Gryphon
OSPF
PPTP
Quake
Quake2
Quake3
Rsync
SMB
SMPP
TSP
Mount
PPP
DCERPC
ASN.1
BGP
WTP
DNS
802.11
ISAKMP
WSP
CLNP
ISIS
RMI

Solution : http://rhn.redhat.com/errata/RHSA-2003-077.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Ethereal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"ethereal-0.9.13-1.AS21.1", yank:"AS", prefix:"ethereal-", release:"RHEL2.1") ) 
	security_hole(0);


