#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12374);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2003-0107");
			
 name["english"] = "RHSA-2003-081: zlib";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of zlib which is vulnerable
to an overflow.

Zlib is a data compression library that is used by different programs
on a Linux machine.  This version of zlib is vulnerable to a bug
when processing a malformed, compressed file.  An attacker, exploiting
this flaw, would need to be able to coerce a local user into opening
a file with some application that used zlib.

Solution : http://rhn.redhat.com/errata/RHSA-2003-081.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the zlib package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"zlib-1.1.4-8.2.1AS", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


