#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12375);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2003-0108");
			
 name["english"] = "RHSA-2003-085: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a verson of tcpdump which allows
for a remote overflow.

Tcpdump is a product for sniffing network traffic.  There is 
a flaw in this version of tcpdump which allows remote attacks
to execute code on the local system.  The flaw is in the tcpdump
protocol analysis of the ISAKMP protocol.  An attacker, exploiting 
this flaw, would need to know that tcpdump is sniffing ISAKMP 
traffic and send a malformed packet to the host.

Solution : http://rhn.redhat.com/errata/RHSA-2003-085.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"tcpdump-3.6.2-12.2.1AS.2", yank:"AS", prefix:"tcpdump-", release:"RHEL2.1") ) 
	security_hole(0);


