#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12376);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2003-0102");
			
 name["english"] = "RHSA-2003-087: file";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of file prior to 3.42.

File is a utility for displaying information about a given file.
This version is vulnerable to a flaw wherein arbitrary code may
be executed when file processes a malicious file.  An attacker,
exploiting this flaw, would need to be able to craft a malicious
file and coerce a local user into running the 'file' application
on the file.

Solution : http://rhn.redhat.com/errata/RHSA-2003-087.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the file package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"file-3.39-8.7x", yank:"x", release:"RHEL2.1") ) 
	security_hole(0);


