#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12377);
 script_bugtraq_id(7123);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0028");
			
 name["english"] = "RHSA-2003-090: glibc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of glibc prior to 2.3.2.

Glibc is a package of standard libraries which are used by many
different programs on a Linux system.  There is a flaw
in this version of Glibc.  Specifically, a flaw in the XDR
mechanism (used to decoding/encoding data structures for use in
RPC) can lead to remote exploitation by an attacker.  

An attacker, exploiting these flaws, would need to  have
access to a network-based application which used the glibc XDR
libraries (such as RPC).

Solution : http://rhn.redhat.com/errata/RHSA-2003-090.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the glibc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"glibc-2.2.4-32.3", prefix:"glibc-", release:"RHEL2.1") ) 
	security_hole(0);


