#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12378);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0073","CAN-2003-0150");
			
 name["english"] = "RHSA-2003-094: mysqlclient";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of MySQL prior to 3.23.55.

MySQL is a multi-user, multi-threaded SQL database server.  This 
version of MySQL is vulnerable to a remote Denial of Service (DoS)
attack, which could render the service unavailable.  An attacker,
exploiting this flaw, would need network access to the MySQL ports
and the ability to craft a malicious packet.

Solution : http://rhn.redhat.com/errata/RHSA-2003-094.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysqlclient package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mysql-3.23.56-1.72", prefix:"mysql-", release:"RHEL2.1") ) 
	security_warning(0);


